/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino.dsl;

import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.DSLHelpers;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.LambdaBaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectsDSL {
    public static void use(Context cx, Scriptable scope) {
        if (scope.has(cx, ".use_effects", scope)) {
            return;
        }
        scope.put(cx, "effect", scope, (Object)new LambdaBaseFunction(EffectsDSL::findEffect));
        scope.put(cx, "effectInstance", scope, (Object)new LambdaBaseFunction(EffectsDSL::makeEffectInstance));
        scope.put(cx, ".use_effects", scope, (Object)true);
    }

    private static Object findEffect(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        MobEffect effect = (MobEffect)DSLHelpers.find(ForgeRegistries.MOB_EFFECTS, (String)args[0]);
        return DSLHelpers.wrap(cx, ScriptableObject.getTopLevelScope((Scriptable)scope), effect, MobEffect.class);
    }

    private static Object makeEffectInstance(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        MobEffect effect = (MobEffect)DSLHelpers.getRegistryEntry(args[0], ForgeRegistries.MOB_EFFECTS);
        int duration = DSLHelpers.getInt(args[1]);
        int amplifier = 0;
        boolean ambient = false;
        boolean visible = true;
        if (args.length >= 3) {
            amplifier = ((Number)args[2]).intValue();
        }
        if (args.length >= 4) {
            ambient = (Boolean)args[3];
        }
        if (args.length >= 5) {
            visible = (Boolean)args[4];
        }
        MobEffectInstance mobEffectInstance = new MobEffectInstance(effect, duration, amplifier, ambient, visible);
        return DSLHelpers.wrap(cx, scope, mobEffectInstance, MobEffectInstance.class);
    }
}

